'use strict';

/* --------------------------------------------------------------
   PayPalLoader.js 2020-05-04
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

(function () {
	if (window.NodeList && !NodeList.prototype.forEach) {
		NodeList.prototype.forEach = Array.prototype.forEach;
	}

	var currentScript = document.currentScript;

	var initDisplayModeECS_ButtonReplace = function initDisplayModeECS_ButtonReplace() {
		var paypalButtonContainer = document.querySelector('#paypal-button-container'),
		    footerTotalRow = document.querySelector('table.order-total tr.footer.total'),
		    newTotalRow = document.createElement('tr'),
		    newTotalRowCell = document.createElement('td');
		newTotalRowCell.colSpan = '2';
		newTotalRowCell.style.width = '100%';
		newTotalRowCell.style.borderTop = 'none';
		newTotalRowCell.appendChild(paypalButtonContainer);
		newTotalRow.appendChild(newTotalRowCell);
		footerTotalRow.parentNode.appendChild(newTotalRow);
		footerTotalRow.querySelectorAll('td').forEach(function (td) {
			td.style.paddingBottom = '15px';
		});
	};

	var initDisplayModeECS = function initDisplayModeECS() {
		if (window.location.search.match(/(\?|&)display_mode=ecs($|&)/)) {
			var checkoutButtons = document.querySelector('div.checkout-buttons');
			if (checkoutButtons) {
				checkoutButtons.style.display = 'none';
			}
			var checkoutSubmitButton = document.querySelector('div.shopping-cart-button a.button-submit');
			if (checkoutSubmitButton === null) {
				checkoutSubmitButton = document.querySelector('tr.checkout-button');
			}
			if (checkoutSubmitButton) {
				checkoutSubmitButton.style.display = 'none';
			}
			var shoppingCartButton = document.querySelector('div.shopping-cart-button');
			if (shoppingCartButton) {
				shoppingCartButton.classList.add('paypal-ecs-mode');
			}
			var ppiContainer = document.querySelector('div.paypalinstallmentcontainer');
			if (ppiContainer) {
				ppiContainer.style.display = 'none';
			}
			initDisplayModeECS_ButtonReplace();
		}
	};

	var initJSSDKPayPalButtonECS = function initJSSDKPayPalButtonECS() {
		var buttonContainer = document.querySelector('#paypal-button-container');
		if (!buttonContainer) {
			return;
		}

		initDisplayModeECS();

		paypal.Buttons({
			style: payPalButtonSettings.style,
			createOrder: function createOrder(data, actions) {
				return $.ajax({
					url: payPalButtonSettings.createPaymentUrl,
					dataType: 'json'
				}).then(function (data) {
					var token = void 0;
					if (data.payment) {
						for (var link in data.payment.links) {
							if (data.payment.links[link].rel === 'approval_url') {
								token = data.payment.links[link].href.match(/EC-\w+/)[0];
							}
						}
					} else {
						//throw new Error(payPalText.paypalUnavailable);
						return false;
					}
					return token;
				});
			},
			onApprove: function onApprove(data, actions) {
				$.ajax({
					url: payPalButtonSettings.authorizedPaymentUrl,
					method: 'post',
					headers: {
						'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
					},
					data: 'paymentID=' + data.paymentID + '&payerID=' + data.payerID
				}).then(function (res) {
					console.debug(res);
					document.location = payPalButtonSettings.checkoutUrl;
				});
			},
			onError: function onError(err) {
				var ppButtonContainer = document.querySelector('#paypal-button-container');
				var ecsIntro = document.querySelector('div.ecs_intro');
				if (ppButtonContainer) {
					var errorMessage = document.querySelector('div.paypal-error');
					if (!errorMessage) {
						errorMessage = document.createElement('div');
						errorMessage.classList.add('paypal-error');
						errorMessage.classList.add('alert');
						errorMessage.classList.add('alert-warning');
						errorMessage.style.textAlign = 'left';
						errorMessage.style.color = '#555';
					}
					errorMessage.innerText = payPalText.paypalUnavailable + ' ';
					var shoppingCartButton = document.querySelector('div.shopping-cart-button');
					if (shoppingCartButton && shoppingCartButton.classList.contains('paypal-ecs-mode')) {
						var linkUrl = window.location.toString().replace('display_mode=ecs', 'display_mode=normal');
						var continueLink = document.createElement('a');
						continueLink.setAttribute('href', linkUrl);
						continueLink.innerText = payPalText.errorContinue;
						errorMessage.append(continueLink);
					}
					ppButtonContainer.parentNode.append(errorMessage);
					ppButtonContainer.style.display = 'none';
				}
				if (ecsIntro) {
					ecsIntro.style.display = 'none';
				}
			}
		}).render('#paypal-button-container');

		document.querySelector('div.ecs_intro').style.display = 'block';

		var observerTarget = document.querySelector('#paypal-button-container');
		var observer = new MutationObserver(function (mutations, observer) {
			mutations.forEach(function (mutation) {
				// console.debug(mutation);
				if (mutation.removedNodes.length > 0) {
					console.info('re-init PayPal buttons');
					initJSSDKPayPalButtonECS();
				}
			});
		});
		observer.observe(observerTarget, { childList: true });
	};

	var initJSSDKPayPalButtonECM = function initJSSDKPayPalButtonECM() {
		paypal.Buttons({
			style: payPalButtonSettings.style,
			createOrder: function createOrder(data, actions) {
				return $.ajax({
					url: payPalButtonSettings.createPaymentUrl,
					dataType: 'json'
				}).then(function (data) {
					var token = void 0;
					for (var link in data.payment.links) {
						if (data.payment.links[link].rel === 'approval_url') {
							token = data.payment.links[link].href.match(/EC-\w+/)[0];
						}
					}
					return token;
				});
			},
			onApprove: function onApprove(data, actions) {
				document.querySelector('#checkout_payment input[name="PayPal2HubPaymentId"]').value = data.paymentID;
				document.querySelector('#checkout_payment input[name="PayPal2HubPayerId"]').value = data.payerID;
				document.querySelector('#checkout_payment').submit();
			}
		}).render('#paypal-button-container');
	};

	var initCheckoutPayment = function initCheckoutPayment() {
		var continueButtonBlock = document.querySelector('#checkout_payment div.continue_button'),
		    continueButton = continueButtonBlock.querySelector('input[type="submit"]'),
		    continueButtonDisplay = continueButton.style.display,
		    paypalButtonContainer = document.createElement('div'),
		    plusContainer = document.querySelector('#gambiohub-ppplus');

		if (plusContainer === null && !payPalButtonSettings.paymentApproved) {
			paypalButtonContainer.id = 'paypal-button-container';
			paypalButtonContainer.style.display = 'none';
			paypalButtonContainer.style.marginTop = '-3px';
			continueButtonBlock.appendChild(paypalButtonContainer);

			initJSSDKPayPalButtonECM();

			var paymentItemClickListener = function paymentItemClickListener() {
				var selected_payment = this.querySelector('input[name="payment"]');
				if (null !== selected_payment) {
					if (selected_payment.value === 'gambio_hub' && selected_payment.dataset.module_code === 'PayPal2Hub') {
						continueButton.style.display = 'none';
						paypalButtonContainer.style.display = 'block';
					} else {
						continueButton.style.display = continueButtonDisplay;
						paypalButtonContainer.style.display = 'none';
					}
				}
			};

			var paymentItems = document.querySelectorAll('#checkout_payment input[name="payment"], #checkout_payment li.list-group-item');
			paymentItems.forEach(function (paymentItem) {
				paymentItem.addEventListener('click', paymentItemClickListener);
			});

			var paymentListEntries = document.querySelectorAll('#checkout_payment li');
			paymentListEntries.forEach(function (paymentOption) {
				if (paymentOption.querySelector('input[name="payment"]:checked') || paymentListEntries.length === 1) {
					paymentOption.dispatchEvent(new Event('click'));
				}
			});
		}
	};

	/****
  ****  Installment Banners
 	 */

	var initInstallmentBanners = function initInstallmentBanners() {
		console.info('Initialising PayPal Installments banners');
		console.info('CartAmount = ' + payPalBannerSettings.cartAmount);
		var banners = document.querySelectorAll('.paypal-installments');
		banners.forEach(function (bannerElement) {
			var position = bannerElement.dataset.ppinstPos;
			console.info('found banner on position ' + position);
			if (payPalBannerSettings.positions && payPalBannerSettings.positions[position]) {
				console.info('settings found for position ' + position);
				console.debug(payPalBannerSettings.positions[position]);
				if (payPalBannerSettings.positions[position].style.layout === 'none') {
					console.info('position disabled');
					return;
				}

				var amount = 0.00;
				if (payPalBannerSettings.cartAmount) {
					amount += payPalBannerSettings.cartAmount;
				}
				var p = document.querySelector('div.current-price-container');
				if (p) {
					amount += 0.01 * parseFloat(p.innerText.replace(/.*?(((\d{1,3}[.,])+)(\d{2})).*/, '$1').replace(/[.,]/g, ''));
				}
				if (amount === 0.00) {
					console.debug('Not showing PayPal Installments banner for amount ' + amount);
				}

				if (bannerElement.classList.contains('paypal-installments-cartbottom')) {
					var observerTarget = document.querySelector('div.shopping-cart-button');
					if (observerTarget) {
						var cartSumElement = document.querySelector('tr.total.sum td:nth-child(2)');
						var amountString = '0';
						if (cartSumElement) {
							amountString = cartSumElement.textContent.trim();
						} else {
							cartSumElement = document.querySelector('tr.footer.total td:nth-child(2)');
							if (cartSumElement) {
								amountString = cartSumElement.textContent.trim().replace(/(\n|\t|\.|\,)/g, '').replace(/.*?([0-9.,]+)\s+EUR.*/, '$1');
							}
						}
						amount = 0.01 * parseInt(amountString.replace(/[^0-9]/g, ''));
						console.info('cart amount ' + amount);

						var observer = new MutationObserver(function (mutations, observer) {
							mutations.forEach(function (mutation) {
								if (mutation.removedNodes.length > 0) {
									console.info('re-init PayPal installments banner');
									initInstallmentBanners();
								}
							});
						});
						observer.observe(observerTarget, { childList: true });
					}
				}

				paypal.Messages({
					amount: amount,
					currency: payPalBannerSettings.currency,
					style: payPalBannerSettings.positions[position].style,
					countryCode: payPalBannerSettings.locale
				}).render(bannerElement).then(function () {
					var legacyInstallmentContainer = document.querySelector('.paypalinstallmentcontainer');
					if (legacyInstallmentContainer) {
						legacyInstallmentContainer.remove();
					}
				});
			}
		});
	};

	var paypalSdkLoaded = function paypalSdkLoaded() {
		console.info('PayPalSDK loaded');
		if (window.location.pathname.match(/shopping_cart.php/)) {
			console.info('Initializing ECS button');
			initJSSDKPayPalButtonECS();
		}
		if (window.location.pathname.match(/checkout_payment.php/)) {
			console.info('Initializing PayPal on payment page');
			initCheckoutPayment();
		}
		initInstallmentBanners();
	};

	var readyCallback = function readyCallback() {
		if (typeof window.paypal === 'undefined') {
			if (!payPalButtonSettings.jssrc) {
				return;
			}

			var jssdk = document.createElement('script');
			jssdk.src = payPalButtonSettings.jssrc ? payPalButtonSettings.jssrc : payPalBannerSettings.jssrc;
			jssdk.onload = paypalSdkLoaded;

			if (currentScript) {
				currentScript.parentNode.insertBefore(jssdk, currentScript);
			} else {
				document.querySelector('script:last-of-type').parentNode.appendChild(jssdk);
			}
		}
	};

	if (document.readyState === 'complete' || document.readyState !== 'loading' && !document.documentElement.doScroll) {
		readyCallback();
	} else {
		document.addEventListener('DOMContentLoaded', readyCallback);
	}
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
